package it.eng.eremita.servlet;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

import javax.imageio.ImageIO;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import it.eng.eremita.jpa.entity.DatiBinari;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;

@WebServlet(urlPatterns = {"/download/*","/thumbnail/*"})
public class DownloadServlet extends HttpServlet {
	

	public void init(ServletConfig servletConfig) throws ServletException {

	}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response){
		   doPost(request, response);
		}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response){
		
		System.out.println("INVOKED");
		EremitaManager eremitaManager;
		
		try {
 			Properties props=new Properties();		
	        Context ctx = new InitialContext(props);
	        
	        eremitaManager = (EremitaManager)ctx.lookup(Accessor.eremitaManagerJndi);
	        if (eremitaManager==null) {
	        	response.sendError(500);
				return;
	        }

		} catch (Exception e ) {
			e.printStackTrace();
			try {
				response.sendError(500);
			}catch (Exception e2) {
				e2.printStackTrace();
			}
			return;
		}
		
		String uri = request.getRequestURI();
		String uuid = uri.substring(uri.lastIndexOf('/') + 1);
		
		try {
			
			if (uuid==null || uuid.equals(""))  {
				response.sendError(404);
				return;
			}
			
			boolean thumbnail = uri.contains("thumbnail");
			
			try {
				ArrayList<Object> a = new ArrayList<Object>();
				a.add(uuid);
				Documento doc = (Documento)eremitaManager.getSqlSingleResult(Documento.class, "select * from eremita_documento where uuid=?",a);
				DatiBinari db = (DatiBinari)eremitaManager.getById(DatiBinari.class, uuid);
				if (db==null || doc==null) {
					response.sendError(404);
					return;
				}
				
				byte[] dati = (thumbnail?db.getAnteprima():db.getDati());
				if (dati==null) {
					
					//manda un redirect a un'icona
					String form = doc.getFormato();
					if (form==null) form = "unknown"; else form = form.toLowerCase();
					response.setHeader("Location", "/LifeEremitaWeb/icone/"+form+".svg");
					
					response.sendError(301);
					return;
				}
				
				if (doc.getFormato()!=null) {
					if (doc.getFormato().toLowerCase().equals("pdf"))
						response.setContentType("application/pdf");
					else if (doc.getFormato().toLowerCase().equals("doc"))
						response.setContentType("application/msword");
					else response.setContentType("image/"+doc.getFormato().toLowerCase());
				}
				response.setContentLength(dati.length);
				response.setHeader("Cache-Control", "private, max-age=31536000");
				response.getOutputStream().write(dati);
				
				
			} catch (Exception e) {
				e.printStackTrace();
				response.sendError(500);
				return;
			}
			
	
			
			
		} catch (Exception e) {
			e.printStackTrace();
			//response.sendError(404);
		}
		
	}


	

	
	
}
